export interface AppSettings {
  autoFetchIntervalMinutes: number;
  podcastCacheLimit: number;
  episodeCacheLimit: number;
  autoClearCacheThresholdMb: number;
}

export const SETTINGS_DEFAULTS: AppSettings;

export function getSettings(): Promise<AppSettings>;
export function setSettings(settings: AppSettings): Promise<AppSettings>;
export function updateSettings(patch: Partial<AppSettings>): Promise<AppSettings>;
export function subscribeToSettings(callback: (settings: AppSettings) => void): () => void;
export function normalizeSettings(input: Partial<AppSettings> | unknown): AppSettings;
