import { describe, it, expect, beforeEach } from 'vitest';
import chrome from 'sinon-chrome';
import { getSubscriptions } from './subscription-store.js';

describe('subscription-store', () => {
  beforeEach(() => {
    chrome.flush();
  });

  describe('getSubscriptions', () => {
    it('应返回订阅列表', async () => {
      const mockData = {
        subscriptions: [
          { sourceRef: 'podcast1', source: 'xiaoyuzhou', addedAt: 1000 },
          { sourceRef: 'podcast2', source: 'xiaoyuzhou', addedAt: 2000 },
        ],
      };

      chrome.storage.sync.get.resolves(mockData);

      const result = await getSubscriptions();

      expect(result).toHaveLength(2);
      expect(result[0]).toHaveProperty('sourceRef');
      expect(result[0]).toHaveProperty('source');
    });
  });
});
